package com.xforceplus.ultraman.app.jcprojectoperation.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * industry_nature_properties_list
 * </p>
 *
 * @author ultraman
 * @since 2024-03-18
 */
public enum IndustryNaturePropertiesList {

    _01("01", "成品油生产企业"),
    _02("02", "成品油经销企业"),
    _03("03", "国内机动车生产企业"),
    _04("04", "进口机动车生产企业驻我国办事机构或总授权代理机构"),
    _05("05", "机动车授权经销企业"),
    _06("06", "其他机动车贸易商"),
    _07("07", "二手车市场"),
    _08("08", "二手车经销企业"),
    _09("09", "二手车拍卖企业"),
    _10("10", "稀土矿产企业"),
    _11("11", "稀土冶炼分离企业"),
    _12("12", "稀土其他企业"),
    _13("13", "稀土矿产企业、稀土冶炼分离企业、稀土其他企业"),
    _14("14", "稀土矿产企业、稀土冶炼分离企业"),
    _15("15", "稀土矿产企业、稀土其他企业"),
    _16("16", "稀土冶炼分离企业、稀土其他企业"),
    _17("17", "卷烟生产企业"),
    _18("18", "卷烟批发企业"),
    _19("19", "卷烟出口企业"),
    _20("20", "生产型出口企业"),
    _21("21", "外贸型出口企业"),
    _22("22", "外贸综合服务企业"),
    _23("23", "自贸区试点企业"),
    _24("24", "特殊监管区内企业"),
    _25("25", "增值税一般纳税人资格试点"),
    _26("26", "市场采购试点"),
    _27("27", "退税商店"),
    _28("28", "电子商务出口企业"),
    _29("29", "享受出口退税政策的融资租赁企业"),
    _30("30", "增值税零税率应税服务提供者"),
    _31("31", "房地产开发企业"),
    _32("32", "农产品深加工企业"),
    _33("33", "外购石脑油、燃料油用于消费税退税企业"),
    _34("34", "从事机动车进口的其他贸易商"),
    _35("35", "自产农产品者"),
    _36("36", "农产品收购企业"),
    _37("37", "光伏收购企业"),
    _38("38", "住房租赁企业"),
    _39("39", "冬奥会退税企业");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    IndustryNaturePropertiesList(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IndustryNaturePropertiesList fromCode(String code){
        switch(code) {
            case "01":
                return _01;
            case "02":
                return _02;
            case "03":
                return _03;
            case "04":
                return _04;
            case "05":
                return _05;
            case "06":
                return _06;
            case "07":
                return _07;
            case "08":
                return _08;
            case "09":
                return _09;
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            case "13":
                return _13;
            case "14":
                return _14;
            case "15":
                return _15;
            case "16":
                return _16;
            case "17":
                return _17;
            case "18":
                return _18;
            case "19":
                return _19;
            case "20":
                return _20;
            case "21":
                return _21;
            case "22":
                return _22;
            case "23":
                return _23;
            case "24":
                return _24;
            case "25":
                return _25;
            case "26":
                return _26;
            case "27":
                return _27;
            case "28":
                return _28;
            case "29":
                return _29;
            case "30":
                return _30;
            case "31":
                return _31;
            case "32":
                return _32;
            case "33":
                return _33;
            case "34":
                return _34;
            case "35":
                return _35;
            case "36":
                return _36;
            case "37":
                return _37;
            case "38":
                return _38;
            case "39":
                return _39;
            default:
                return null;
        }
    }
}
