package com.xforceplus.ultraman.app.jcprojectoperation.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_style_type
 * </p>
 *
 * @author ultraman
 * @since 2024-03-18
 */
public enum InvoiceStyleType {

    _01("01", "成品油发票"),
    _02("02", "稀土发票"),
    _03("03", "建筑服务发票"),
    _04("04", "货物运输服务发票"),
    _05("05", "不定产销售服务发票"),
    _06("06", "不动产租赁服务发票"),
    _07("07", "代收车船税"),
    _08("08", "通行费"),
    _09("09", "旅客运输服务发票"),
    _10("10", "医疗服务（住院）发票"),
    _11("11", "医疗服务（门诊）发票"),
    _12("12", "自产农产品销售服务"),
    _13("13", "拖拉机和联合收割机发票"),
    _14("14", "机动车"),
    _15("15", "二手车"),
    _16("16", "农产品收购发票"),
    _17("17", "光伏收购发票"),
    _18("18", "卷烟发票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceStyleType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceStyleType fromCode(String code){
        switch(code) {
            case "01":
                return _01;
            case "02":
                return _02;
            case "03":
                return _03;
            case "04":
                return _04;
            case "05":
                return _05;
            case "06":
                return _06;
            case "07":
                return _07;
            case "08":
                return _08;
            case "09":
                return _09;
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            case "13":
                return _13;
            case "14":
                return _14;
            case "15":
                return _15;
            case "16":
                return _16;
            case "17":
                return _17;
            case "18":
                return _18;
            default:
                return null;
        }
    }
}
