package com.xforceplus.ultraman.app.jcprojectoperation.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoicetype
 * </p>
 *
 * @author ultraman
 * @since 2024-03-18
 */
public enum Invoicetype {

    QC("qc", "数电普电"),
    QS("qs", "数电专电"),
    CZ("cz", "数电普纸"),
    SZ("sz", "数电专纸"),
    CE("ce", "税控普电"),
    C("c", "税控普纸"),
    SE("se", "税控专电"),
    S("s", "税控专纸");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    Invoicetype(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Invoicetype fromCode(String code){
        switch(code) {
            case "qc":
                return QC;
            case "qs":
                return QS;
            case "cz":
                return CZ;
            case "sz":
                return SZ;
            case "ce":
                return CE;
            case "c":
                return C;
            case "se":
                return SE;
            case "s":
                return S;
            default:
                return null;
        }
    }
}
