package com.xforceplus.ultraman.app.jcprojectoperation.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * pretimeout
 * </p>
 *
 * @author ultraman
 * @since 2024-03-18
 */
public enum Pretimeout {

    _1("1", "0-10min"),
    _2("2", "10min-1h"),
    _3("3", "1h-0.5d"),
    _4("4", "0.5d-1d"),
    _5("5", "1d-2d"),
    _6("6", "2d-3d");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    Pretimeout(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Pretimeout fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            default:
                return null;
        }
    }
}
