package com.xforceplus.ultraman.app.jcprojectoperation.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * settlement_mode
 * </p>
 *
 * @author ultraman
 * @since 2024-03-18
 */
public enum SettlementMode {

    _01("01", "现金"),
    _02("02", "银行转账"),
    _03("03", "票据"),
    _04("04", "第三方支付"),
    _05("05", "预付卡"),
    _99("99", "其他");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SettlementMode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SettlementMode fromCode(String code){
        switch(code) {
            case "01":
                return _01;
            case "02":
                return _02;
            case "03":
                return _03;
            case "04":
                return _04;
            case "05":
                return _05;
            case "99":
                return _99;
            default:
                return null;
        }
    }
}
