package com.xforceplus.ultraman.app.jcprojectoperation.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * taxpayer_credit_rating
 * </p>
 *
 * @author ultraman
 * @since 2024-03-18
 */
public enum TaxpayerCreditRating {

    A("A", "A"),
    B("B", "B"),
    C("C", "C"),
    D("D", "D"),
    M("M", "M");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TaxpayerCreditRating(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaxpayerCreditRating fromCode(String code){
        switch(code) {
            case "A":
                return A;
            case "B":
                return B;
            case "C":
                return C;
            case "D":
                return D;
            case "M":
                return M;
            default:
                return null;
        }
    }
}
