package com.xforceplus.ultraman.app.jcprojectoperation.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * taxpayer_risk_type
 * </p>
 *
 * @author ultraman
 * @since 2024-03-18
 */
public enum TaxpayerRiskType {

    _01("01", "Ⅰ类（高风险）纳税人"),
    _02("02", "Ⅱ类（中风险）纳税人"),
    _03("03", "Ⅲ类（低风险）纳税人"),
    _04("04", "Ⅳ类（无风险）纳税人");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TaxpayerRiskType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaxpayerRiskType fromCode(String code){
        switch(code) {
            case "01":
                return _01;
            case "02":
                return _02;
            case "03":
                return _03;
            case "04":
                return _04;
            default:
                return null;
        }
    }
}
