package com.xforceplus.ultraman.app.jcprojectoperation.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * vat_refund_type
 * </p>
 *
 * @author ultraman
 * @since 2024-03-18
 */
public enum VatRefundType {

    _01("01", "软件产品发票"),
    _02("02", "资源综合利用产品发票"),
    _03("03", "管道运输服务发票"),
    _04("04", "有形动产融资租赁服务"),
    _05("05", "有形动产融资性售后回族服务发票"),
    _06("06", "新型墙体材料发票"),
    _07("07", "风力发电产品发票"),
    _08("08", "光伏发电产品发票"),
    _09("09", "动漫软件产品发票"),
    _10("10", "飞机维修劳务发票"),
    _11("11", "黄金发票"),
    _12("12", "铂金发票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    VatRefundType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static VatRefundType fromCode(String code){
        switch(code) {
            case "01":
                return _01;
            case "02":
                return _02;
            case "03":
                return _03;
            case "04":
                return _04;
            case "05":
                return _05;
            case "06":
                return _06;
            case "07":
                return _07;
            case "08":
                return _08;
            case "09":
                return _09;
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            default:
                return null;
        }
    }
}
