package com.xforceplus.ultraman.app.jcprojectoperation.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-03-18
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceList implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 蓝字发票标志
   */
  @TableField("invoiceFlag")
  private String invoiceFlag;

  /**
   * 单据号码
   */
  @TableField("billNo")
  private String billNo;

  /**
   * 发票类型
   */
  @TableField("invoiceType")
  private String invoiceType;

  /**
   * 特定要素
   */
  @TableField("invoiceStyleType")
  private String invoiceStyleType;

  /**
   * 增值税即征即退代码
   */
  @TableField("vatRefundType")
  private String vatRefundType;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 结算方式
   */
  @TableField("settlementMode")
  private String settlementMode;

  /**
   * 销方税号
   */
  @TableField("sellerTaxNo")
  private String sellerTaxNo;

  /**
   * 销售方名称
   */
  @TableField("sellerName")
  private String sellerName;

  /**
   * 销售方地址
   */
  @TableField("sellerAddress")
  private String sellerAddress;

  /**
   * 销售方电话
   */
  @TableField("sellerTel")
  private String sellerTel;

  /**
   * 销售方开户行
   */
  @TableField("sellerBankName")
  private String sellerBankName;

  /**
   * 销售方账号
   */
  @TableField("sellerBankAccount")
  private String sellerBankAccount;

  /**
   * 购方税号
   */
  @TableField("buyerTaxNo")
  private String buyerTaxNo;

  /**
   * 购买方名称
   */
  @TableField("buyerName")
  private String buyerName;

  /**
   * 购买方地址
   */
  @TableField("buyerAddress")
  private String buyerAddress;

  /**
   * 购买方电话
   */
  @TableField("buyerTel")
  private String buyerTel;

  /**
   * 购买方开户行
   */
  @TableField("buyerBankName")
  private String buyerBankName;

  /**
   * 购买方账号
   */
  @TableField("buyerBankAccount")
  private String buyerBankAccount;

  /**
   * 是否自然人标识
   */
  @TableField("isNature")
  private Boolean isNature;

  /**
   * 购买方经办人姓名
   */
  @TableField("buyerOperatorName")
  private String buyerOperatorName;

  /**
   * 购买方经办人证件号码
   */
  @TableField("buyerOperatorIdentityNo")
  private String buyerOperatorIdentityNo;

  /**
   * 购买方经办人联系电话
   */
  @TableField("buyerOperatorTel")
  private String buyerOperatorTel;

  /**
   * 收款人
   */
  private String payee;

  /**
   * 复核人
   */
  private String reviewer;

  /**
   * 开票人证件号码
   */
  @TableField("issuerIdentityNo")
  private String issuerIdentityNo;

  /**
   * 开票人证件类型
   */
  @TableField("issuerIdentityType")
  private String issuerIdentityType;

  /**
   * 收款银行名称
   */
  @TableField("payeeBankName")
  private String payeeBankName;

  /**
   * 收款银行账号
   */
  @TableField("payeeBankAccount")
  private String payeeBankAccount;

  /**
   * 合计金额
   */
  @TableField("amountWithoutTax")
  private BigDecimal amountWithoutTax;

  /**
   * 合计税额
   */
  @TableField("taxAmount")
  private BigDecimal taxAmount;

  /**
   * 价税合计
   */
  @TableField("amountWithTax")
  private BigDecimal amountWithTax;

  /**
   * 对应蓝字发票号码
   */
  @TableField("originalInvoiceNo")
  private String originalInvoiceNo;

  /**
   * 红字确认信息单编号
   */
  @TableField("redLetterNumber")
  private String redLetterNumber;

  /**
   * 红字确认单uuid
   */
  @TableField("redLetterUuid")
  private String redLetterUuid;

  /**
   * 备注
   */
  private String remark;

  /**
   * 特定要素对应的key
   */
  private String key;

  /**
   * 特定要素对应的value
   */
  private String value;

  /**
   * 开票人
   */
  private String issuer;

  /**
   * 单据状态
   */
  private String status;

  /**
   * 扩展信息1
   */
  private String ext1;

  /**
   * 扩展信息2
   */
  private String ext2;

  /**
   * 扩展信息3
   */
  private String ext3;

  /**
   * 扩展信息4
   */
  private String ext4;

  /**
   * 扩展信息5
   */
  private String ext5;

  /**
   * 异常信息
   */
  private String errorinfo;

  /**
   * 发票号码
   */
  @TableField("invoiceNo")
  private String invoiceNo;

  /**
   * 开票日期
   */
  @TableField("invoiceDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime invoiceDate;

  /**
   * xml文件地址
   */
  private String xmlurl;

  /**
   * pdf文件地址
   */
  private String pdfurl;

  /**
   * ofd文件地址
   */
  private String ofdurl;

  /**
   * 开票方式
   */
  @TableField("invoicingMethod")
  private String invoicingMethod;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("invoiceFlag", invoiceFlag);
      map.put("billNo", billNo);
      map.put("invoiceType", invoiceType);
      map.put("invoiceStyleType", invoiceStyleType);
      map.put("vatRefundType", vatRefundType);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("settlementMode", settlementMode);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("sellerName", sellerName);
      map.put("sellerAddress", sellerAddress);
      map.put("sellerTel", sellerTel);
      map.put("sellerBankName", sellerBankName);
      map.put("sellerBankAccount", sellerBankAccount);
      map.put("buyerTaxNo", buyerTaxNo);
      map.put("buyerName", buyerName);
      map.put("buyerAddress", buyerAddress);
      map.put("buyerTel", buyerTel);
      map.put("buyerBankName", buyerBankName);
      map.put("buyerBankAccount", buyerBankAccount);
      map.put("isNature", isNature);
      map.put("buyerOperatorName", buyerOperatorName);
      map.put("buyerOperatorIdentityNo", buyerOperatorIdentityNo);
      map.put("buyerOperatorTel", buyerOperatorTel);
      map.put("payee", payee);
      map.put("reviewer", reviewer);
      map.put("issuerIdentityNo", issuerIdentityNo);
      map.put("issuerIdentityType", issuerIdentityType);
      map.put("payeeBankName", payeeBankName);
      map.put("payeeBankAccount", payeeBankAccount);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("taxAmount", taxAmount);
      map.put("amountWithTax", amountWithTax);
      map.put("originalInvoiceNo", originalInvoiceNo);
      map.put("redLetterNumber", redLetterNumber);
      map.put("redLetterUuid", redLetterUuid);
      map.put("remark", remark);
      map.put("key", key);
      map.put("value", value);
      map.put("issuer", issuer);
      map.put("status", status);
      map.put("ext1", ext1);
      map.put("ext2", ext2);
      map.put("ext3", ext3);
      map.put("ext4", ext4);
      map.put("ext5", ext5);
      map.put("errorinfo", errorinfo);
      map.put("invoiceNo", invoiceNo);
      map.put("invoiceDate", BocpGenUtils.toTimestamp(invoiceDate));
      map.put("xmlurl", xmlurl);
      map.put("pdfurl", pdfurl);
      map.put("ofdurl", ofdurl);
      map.put("invoicingMethod", invoicingMethod);

      return map;
  }

  public static InvoiceList fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceList entity = new InvoiceList();
    if(map.containsKey("invoiceFlag")) {
      Object obj = map.get("invoiceFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billNo")) {
      Object obj = map.get("billNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceStyleType")) {
      Object obj = map.get("invoiceStyleType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceStyleType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vatRefundType")) {
      Object obj = map.get("vatRefundType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVatRefundType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlementMode")) {
      Object obj = map.get("settlementMode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettlementMode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankAccount")) {
      Object obj = map.get("sellerBankAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerTaxNo")) {
      Object obj = map.get("buyerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerAddress")) {
      Object obj = map.get("buyerAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerTel")) {
      Object obj = map.get("buyerTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerBankName")) {
      Object obj = map.get("buyerBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerBankAccount")) {
      Object obj = map.get("buyerBankAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isNature")) {
      Object obj = map.get("isNature");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsNature((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsNature(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("buyerOperatorName")) {
      Object obj = map.get("buyerOperatorName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerOperatorName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerOperatorIdentityNo")) {
      Object obj = map.get("buyerOperatorIdentityNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerOperatorIdentityNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerOperatorTel")) {
      Object obj = map.get("buyerOperatorTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerOperatorTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payee")) {
      Object obj = map.get("payee");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayee((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reviewer")) {
      Object obj = map.get("reviewer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReviewer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("issuerIdentityNo")) {
      Object obj = map.get("issuerIdentityNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIssuerIdentityNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("issuerIdentityType")) {
      Object obj = map.get("issuerIdentityType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIssuerIdentityType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payeeBankName")) {
      Object obj = map.get("payeeBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayeeBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payeeBankAccount")) {
      Object obj = map.get("payeeBankAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayeeBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("originalInvoiceNo")) {
      Object obj = map.get("originalInvoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginalInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redLetterNumber")) {
      Object obj = map.get("redLetterNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedLetterNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redLetterUuid")) {
      Object obj = map.get("redLetterUuid");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedLetterUuid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("key")) {
      Object obj = map.get("key");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setKey((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("value")) {
      Object obj = map.get("value");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setValue((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("issuer")) {
      Object obj = map.get("issuer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIssuer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("errorinfo")) {
      Object obj = map.get("errorinfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorinfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceDate")) {
      Object obj = map.get("invoiceDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setInvoiceDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setInvoiceDate(null);
      }
    }
    if(map.containsKey("xmlurl")) {
      Object obj = map.get("xmlurl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setXmlurl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pdfurl")) {
      Object obj = map.get("pdfurl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPdfurl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ofdurl")) {
      Object obj = map.get("ofdurl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOfdurl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicingMethod")) {
      Object obj = map.get("invoicingMethod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoicingMethod((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("invoiceFlag")) {
      Object obj = map.get("invoiceFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billNo")) {
      Object obj = map.get("billNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceStyleType")) {
      Object obj = map.get("invoiceStyleType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceStyleType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vatRefundType")) {
      Object obj = map.get("vatRefundType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVatRefundType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("settlementMode")) {
      Object obj = map.get("settlementMode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSettlementMode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerBankAccount")) {
      Object obj = map.get("sellerBankAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyerTaxNo")) {
      Object obj = map.get("buyerTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyerAddress")) {
      Object obj = map.get("buyerAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyerTel")) {
      Object obj = map.get("buyerTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyerBankName")) {
      Object obj = map.get("buyerBankName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyerBankAccount")) {
      Object obj = map.get("buyerBankAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isNature")) {
      Object obj = map.get("isNature");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setIsNature((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setIsNature(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("buyerOperatorName")) {
      Object obj = map.get("buyerOperatorName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerOperatorName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyerOperatorIdentityNo")) {
      Object obj = map.get("buyerOperatorIdentityNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerOperatorIdentityNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyerOperatorTel")) {
      Object obj = map.get("buyerOperatorTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerOperatorTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payee")) {
      Object obj = map.get("payee");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayee((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reviewer")) {
      Object obj = map.get("reviewer");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReviewer((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("issuerIdentityNo")) {
      Object obj = map.get("issuerIdentityNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIssuerIdentityNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("issuerIdentityType")) {
      Object obj = map.get("issuerIdentityType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIssuerIdentityType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payeeBankName")) {
      Object obj = map.get("payeeBankName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayeeBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payeeBankAccount")) {
      Object obj = map.get("payeeBankAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayeeBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("originalInvoiceNo")) {
      Object obj = map.get("originalInvoiceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginalInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("redLetterNumber")) {
      Object obj = map.get("redLetterNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRedLetterNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("redLetterUuid")) {
      Object obj = map.get("redLetterUuid");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRedLetterUuid((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("key")) {
      Object obj = map.get("key");
      if(obj != null) {
        if(obj instanceof String) {
          this.setKey((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("value")) {
      Object obj = map.get("value");
      if(obj != null) {
        if(obj instanceof String) {
          this.setValue((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("issuer")) {
      Object obj = map.get("issuer");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIssuer((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("errorinfo")) {
      Object obj = map.get("errorinfo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setErrorinfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceDate")) {
      Object obj = map.get("invoiceDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setInvoiceDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setInvoiceDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setInvoiceDate(null);
      }
    }
    if(map.containsKey("xmlurl")) {
      Object obj = map.get("xmlurl");
      if(obj != null) {
        if(obj instanceof String) {
          this.setXmlurl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pdfurl")) {
      Object obj = map.get("pdfurl");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPdfurl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ofdurl")) {
      Object obj = map.get("ofdurl");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOfdurl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoicingMethod")) {
      Object obj = map.get("invoicingMethod");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoicingMethod((String)obj);
        }
      } else {
      }
    }
  }
}
