package com.xforceplus.ultraman.app.jcprojectoperation.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * confirm_status
 * </p>
 *
 * @author ultraman
 * @since 2024-06-03
 */
public enum ConfirmStatus {

    _1("1", "已开具"),
    _0("0", "未开具");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ConfirmStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ConfirmStatus fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "0":
                return _0;
            default:
                return null;
        }
    }
}
