package com.xforceplus.ultraman.app.jcprojectoperation.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * excise_purpose
 * </p>
 *
 * @author ultraman
 * @since 2024-06-03
 */
public enum ExcisePurpose {

    _00("00", "未勾选"),
    _01("01", "已勾选");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ExcisePurpose(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ExcisePurpose fromCode(String code){
        switch(code) {
            case "00":
                return _00;
            case "01":
                return _01;
            default:
                return null;
        }
    }
}
