package com.xforceplus.ultraman.app.jcprojectoperation.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * in_account_status
 * </p>
 *
 * @author ultraman
 * @since 2024-06-03
 */
public enum InAccountStatus {

    _00("00", "未入账"),
    _01("01", "已入账");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InAccountStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InAccountStatus fromCode(String code){
        switch(code) {
            case "00":
                return _00;
            case "01":
                return _01;
            default:
                return null;
        }
    }
}
