package com.xforceplus.ultraman.app.jcprojectoperation.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * tax_incentives_type
 * </p>
 *
 * @author ultraman
 * @since 2024-06-03
 */
public enum TaxIncentivesType {

    _01("01", "简易征收"),
    _02("02", "稀土产品"),
    _03("03", "免税"),
    _04("04", "不征税"),
    _05("05", "先征后退"),
    _06("06", "100%先征后退"),
    _07("07", "50%先征后退"),
    _08("08", "按3%简易征收"),
    _09("09", "按5%简易征收"),
    _10("10", "按5%简易征收减按1.5%计征"),
    _11("11", "即征即退30%"),
    _12("12", "即征即退50%"),
    _13("13", "即征即退70%"),
    _14("14", "即征即退100%"),
    _15("15", "超税负3%即征即退"),
    _16("16", "超税负8%即征即退"),
    _17("17", "超税负12%即征即退"),
    _18("18", "超税负6%即征即退");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TaxIncentivesType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaxIncentivesType fromCode(String code){
        switch(code) {
            case "01":
                return _01;
            case "02":
                return _02;
            case "03":
                return _03;
            case "04":
                return _04;
            case "05":
                return _05;
            case "06":
                return _06;
            case "07":
                return _07;
            case "08":
                return _08;
            case "09":
                return _09;
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            case "13":
                return _13;
            case "14":
                return _14;
            case "15":
                return _15;
            case "16":
                return _16;
            case "17":
                return _17;
            case "18":
                return _18;
            default:
                return null;
        }
    }
}
