package com.xforceplus.ultraman.app.jcprojectoperation.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * v_a_tax_purpose
 * </p>
 *
 * @author ultraman
 * @since 2024-06-03
 */
public enum VATaxPurpose {

    _00("00", "已勾选未确认"),
    _01("01", "已确认"),
    _02("02", "未勾选");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    VATaxPurpose(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static VATaxPurpose fromCode(String code){
        switch(code) {
            case "00":
                return _00;
            case "01":
                return _01;
            case "02":
                return _02;
            default:
                return null;
        }
    }
}
