package com.xforceplus.ultraman.app.jcprojectoperation.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * yor_n
 * </p>
 *
 * @author ultraman
 * @since 2024-06-03
 */
public enum YorN {

    Y("Y", "是"),
    N("N", "否");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    YorN(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static YorN fromCode(String code){
        switch(code) {
            case "Y":
                return Y;
            case "N":
                return N;
            default:
                return null;
        }
    }
}
