package com.xforceplus.ultraman.app.jcprojectoperation.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-06-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ApiErrorLog implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 链路追踪编号
   */
  private String traceId;

  /**
   * 用户编号
   */
  private Long userId;

  /**
   * 用户类型
   */
  private Long userType;

  /**
   * 应用名
   */
  private String applicationName;

  /**
   * 请求方法名
   */
  private String requestMethod;

  /**
   * 请求地址
   */
  private String requestUrl;

  /**
   * 请求参数
   */
  private String requestParams;

  /**
   * 用户 IP
   */
  private String userIp;

  /**
   * 异常发生时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime exceptionTime;

  /**
   * 异常名
   */
  private String exceptionName;

  /**
   * 异常导致的消息
   */
  private String exceptionMessage;

  /**
   * 处理状态
   */
  private Long processStatus;

  /**
   * 处理时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime processTime;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("trace_id", traceId);
      map.put("user_id", userId);
      map.put("user_type", userType);
      map.put("application_name", applicationName);
      map.put("request_method", requestMethod);
      map.put("request_url", requestUrl);
      map.put("request_params", requestParams);
      map.put("user_ip", userIp);
      map.put("exception_time", BocpGenUtils.toTimestamp(exceptionTime));
      map.put("exception_name", exceptionName);
      map.put("exception_message", exceptionMessage);
      map.put("process_status", processStatus);
      map.put("process_time", BocpGenUtils.toTimestamp(processTime));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static ApiErrorLog fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ApiErrorLog entity = new ApiErrorLog();
    if(map.containsKey("trace_id")) {
      Object obj = map.get("trace_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTraceId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("user_id")) {
      Object obj = map.get("user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("user_type")) {
      Object obj = map.get("user_type");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUserType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUserType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUserType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("application_name")) {
      Object obj = map.get("application_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplicationName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("request_method")) {
      Object obj = map.get("request_method");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRequestMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("request_url")) {
      Object obj = map.get("request_url");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRequestUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("request_params")) {
      Object obj = map.get("request_params");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRequestParams((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("user_ip")) {
      Object obj = map.get("user_ip");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUserIp((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_time")) {
      Object obj = map.get("exception_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExceptionTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setExceptionTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExceptionTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setExceptionTime(null);
      }
    }
    if(map.containsKey("exception_name")) {
      Object obj = map.get("exception_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExceptionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_message")) {
      Object obj = map.get("exception_message");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExceptionMessage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("process_status")) {
      Object obj = map.get("process_status");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setProcessStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setProcessStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setProcessStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("process_time")) {
      Object obj = map.get("process_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setProcessTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setProcessTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setProcessTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setProcessTime(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("trace_id")) {
      Object obj = map.get("trace_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTraceId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("user_id")) {
      Object obj = map.get("user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("user_type")) {
      Object obj = map.get("user_type");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUserType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUserType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUserType(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("application_name")) {
      Object obj = map.get("application_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplicationName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("request_method")) {
      Object obj = map.get("request_method");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRequestMethod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("request_url")) {
      Object obj = map.get("request_url");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRequestUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("request_params")) {
      Object obj = map.get("request_params");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRequestParams((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("user_ip")) {
      Object obj = map.get("user_ip");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUserIp((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("exception_time")) {
      Object obj = map.get("exception_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setExceptionTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setExceptionTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExceptionTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setExceptionTime(null);
      }
    }
    if(map.containsKey("exception_name")) {
      Object obj = map.get("exception_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExceptionName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("exception_message")) {
      Object obj = map.get("exception_message");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExceptionMessage((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("process_status")) {
      Object obj = map.get("process_status");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setProcessStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setProcessStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setProcessStatus(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("process_time")) {
      Object obj = map.get("process_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setProcessTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setProcessTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setProcessTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setProcessTime(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
  }
}
