package com.xforceplus.ultraman.app.jcprojectoperation.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 红字确认单明细
 * </p>
 *
 * @author ultraman
 * @since 2024-06-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class RedLetterdetail implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 蓝字发票明细序号
   */
  @TableField("originInvoiceRowNum")
  private String originInvoiceRowNum;

  /**
   * 序号
   */
  @TableField("rowNum")
  private String rowNum;

  /**
   * 明细不含税金额
   */
  @TableField("amountWithoutTax")
  private BigDecimal amountWithoutTax;

  /**
   * 税额
   */
  @TableField("taxAmount")
  private BigDecimal taxAmount;

  /**
   * 商品名称
   */
  @TableField("itemName")
  private String itemName;

  /**
   * 规格型号
   */
  private String specifications;

  /**
   * 单位
   */
  private String unit;

  /**
   * 税率
   */
  @TableField("taxRate")
  private BigDecimal taxRate;

  /**
   * 税编
   */
  @TableField("taxClassCode")
  private String taxClassCode;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 数量
   */
  private BigDecimal quantity;

  /**
   * 单价
   */
  @TableField("unitPrice")
  private BigDecimal unitPrice;


  /**
   * 对一关联关系 关联对象 redLetter
   */
    private Long redLetterrelationId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("originInvoiceRowNum", originInvoiceRowNum);
      map.put("rowNum", rowNum);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("taxAmount", taxAmount);
      map.put("itemName", itemName);
      map.put("specifications", specifications);
      map.put("unit", unit);
      map.put("taxRate", taxRate);
      map.put("taxClassCode", taxClassCode);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("quantity", quantity);
      map.put("unitPrice", unitPrice);

       map.put("redLetterrelation.id", redLetterrelationId);
      return map;
  }

  public static RedLetterdetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    RedLetterdetail entity = new RedLetterdetail();
    if(map.containsKey("originInvoiceRowNum")) {
      Object obj = map.get("originInvoiceRowNum");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginInvoiceRowNum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rowNum")) {
      Object obj = map.get("rowNum");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRowNum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("itemName")) {
      Object obj = map.get("itemName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("specifications")) {
      Object obj = map.get("specifications");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpecifications((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxClassCode")) {
      Object obj = map.get("taxClassCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxClassCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unitPrice")) {
      Object obj = map.get("unitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }

    if(map.containsKey("redLetterrelation.id")) {
        Object obj = map.get("redLetterrelation.id");
      if(obj instanceof Long) {
        entity.setRedLetterrelationId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setRedLetterrelationId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("originInvoiceRowNum")) {
      Object obj = map.get("originInvoiceRowNum");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginInvoiceRowNum((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rowNum")) {
      Object obj = map.get("rowNum");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRowNum((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("itemName")) {
      Object obj = map.get("itemName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("specifications")) {
      Object obj = map.get("specifications");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSpecifications((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("taxClassCode")) {
      Object obj = map.get("taxClassCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxClassCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("unitPrice")) {
      Object obj = map.get("unitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
      if(map.containsKey("redLetterrelation.id")) {
        Object obj = map.get("redLetterrelation.id");
        if(obj instanceof Long) {
          this.setRedLetterrelationId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRedLetterrelationId(Long.parseLong((String)obj));
        }
      }
  }
}
