package com.xforceplus.ultraman.app.jcprojectoperation.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * app_status
 * </p>
 *
 * @author ultraman
 * @since 2024-06-03
 */
public enum AppStatus {

    _1("1", "正常"),
    _0("0", "禁用");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AppStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AppStatus fromCode(String code) {
        return Stream.of(AppStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
