package com.xforceplus.ultraman.app.jcprojectoperation.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * bill_no_exception
 * </p>
 *
 * @author ultraman
 * @since 2024-06-03
 */
public enum BillNoException {

    _1("1", "未生成预制发票"),
    _2("2", "未更新成已开票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BillNoException(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillNoException fromCode(String code) {
        return Stream.of(BillNoException.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
