package com.xforceplus.ultraman.app.jcprojectoperation.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * confirm_status
 * </p>
 *
 * @author ultraman
 * @since 2024-06-03
 */
public enum ConfirmStatus {

    _1("1", "已开具"),
    _0("0", "未开具");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ConfirmStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ConfirmStatus fromCode(String code) {
        return Stream.of(ConfirmStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
