package com.xforceplus.ultraman.app.jcprojectoperation.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * discounttype
 * </p>
 *
 * @author ultraman
 * @since 2024-06-03
 */
public enum Discounttype {

    _00("00", "正常行"),
    _01("01", "折扣行"),
    _02("02", "被折扣行");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Discounttype(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Discounttype fromCode(String code) {
        return Stream.of(Discounttype.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
