package com.xforceplus.ultraman.app.jcprojectoperation.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * excise_purpose
 * </p>
 *
 * @author ultraman
 * @since 2024-06-03
 */
public enum ExcisePurpose {

    _00("00", "未勾选"),
    _01("01", "已勾选");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ExcisePurpose(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ExcisePurpose fromCode(String code) {
        return Stream.of(ExcisePurpose.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
