package com.xforceplus.ultraman.app.jcprojectoperation.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * excise_taxpayer_type_list
 * </p>
 *
 * @author ultraman
 * @since 2024-06-03
 */
public enum ExciseTaxpayerTypeList {

    _01("01", "卷烟生产消费税纳税人"),
    _02("02", "卷烟批发消费税纳税人"),
    _03("03", "白酒生产消费税纳税人"),
    _04("04", "黄酒生产消费税纳税人"),
    _05("05", "啤酒生产消费税纳税人"),
    _06("06", "其他酒生产消费税纳税人"),
    _07("07", "小汽车生产消费税纳税人"),
    _08("08", "超豪华小汽车消费税纳税人"),
    _09("09", "汽油生产消费税纳税人"),
    _10("10", "石脑油生产消费税纳税人"),
    _11("11", "溶剂油生产消费税纳税人"),
    _12("12", "润滑油生产消费税纳税人"),
    _13("13", "柴油生产消费税纳税人"),
    _14("14", "航空煤油生产消费税纳税人"),
    _15("15", "燃料油生产消费税纳税人"),
    _16("16", "电池生产消费税纳税人"),
    _17("17", "涂料生产消费税纳税人"),
    _18("18", "高档化妆品生产消费税纳税人"),
    _19("19", "金银首饰铂金首饰和钻石及钻石饰品零售消费税纳税人"),
    _20("20", "其他贵重首饰和珠宝玉石生产消费税纳税人"),
    _21("21", "鞭炮焰火生产消费税纳税人"),
    _22("22", "摩托车生产消费税纳税人"),
    _23("23", "高尔夫球及球具生产消费税纳税人"),
    _24("24", "高档手表生产消费税纳税人"),
    _25("25", "游艇生产消费税纳税人"),
    _26("26", "木制一次性筷子生产消费税纳税人"),
    _27("27", "实木地板生产消费税纳税人"),
    _28("28", "雪茄烟生产消费税纳税人"),
    _29("29", "烟丝生产消费税纳税人");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ExciseTaxpayerTypeList(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ExciseTaxpayerTypeList fromCode(String code) {
        return Stream.of(ExciseTaxpayerTypeList.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
