package com.xforceplus.ultraman.app.jcprojectoperation.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * export_enterprises_type
 * </p>
 *
 * @author ultraman
 * @since 2024-06-03
 */
public enum ExportEnterprisesType {

    _01("01", "一类出口企业"),
    _02("02", "二类出口企业"),
    _03("03", "三类出口企业"),
    _04("04", "四类出口企业");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ExportEnterprisesType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ExportEnterprisesType fromCode(String code) {
        return Stream.of(ExportEnterprisesType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
