package com.xforceplus.ultraman.app.jcprojectoperation.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * in_account_status
 * </p>
 *
 * @author ultraman
 * @since 2024-06-03
 */
public enum InAccountStatus {

    _00("00", "未入账"),
    _01("01", "已入账");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InAccountStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InAccountStatus fromCode(String code) {
        return Stream.of(InAccountStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
