package com.xforceplus.ultraman.app.jcprojectoperation.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * industry_nature_properties_list
 * </p>
 *
 * @author ultraman
 * @since 2024-06-03
 */
public enum IndustryNaturePropertiesList {

    _01("01", "成品油生产企业"),
    _02("02", "成品油经销企业"),
    _03("03", "国内机动车生产企业"),
    _04("04", "进口机动车生产企业驻我国办事机构或总授权代理机构"),
    _05("05", "机动车授权经销企业"),
    _06("06", "其他机动车贸易商"),
    _07("07", "二手车市场"),
    _08("08", "二手车经销企业"),
    _09("09", "二手车拍卖企业"),
    _10("10", "稀土矿产企业"),
    _11("11", "稀土冶炼分离企业"),
    _12("12", "稀土其他企业"),
    _13("13", "稀土矿产企业、稀土冶炼分离企业、稀土其他企业"),
    _14("14", "稀土矿产企业、稀土冶炼分离企业"),
    _15("15", "稀土矿产企业、稀土其他企业"),
    _16("16", "稀土冶炼分离企业、稀土其他企业"),
    _17("17", "卷烟生产企业"),
    _18("18", "卷烟批发企业"),
    _19("19", "卷烟出口企业"),
    _20("20", "生产型出口企业"),
    _21("21", "外贸型出口企业"),
    _22("22", "外贸综合服务企业"),
    _23("23", "自贸区试点企业"),
    _24("24", "特殊监管区内企业"),
    _25("25", "增值税一般纳税人资格试点"),
    _26("26", "市场采购试点"),
    _27("27", "退税商店"),
    _28("28", "电子商务出口企业"),
    _29("29", "享受出口退税政策的融资租赁企业"),
    _30("30", "增值税零税率应税服务提供者"),
    _31("31", "房地产开发企业"),
    _32("32", "农产品深加工企业"),
    _33("33", "外购石脑油、燃料油用于消费税退税企业"),
    _34("34", "从事机动车进口的其他贸易商"),
    _35("35", "自产农产品者"),
    _36("36", "农产品收购企业"),
    _37("37", "光伏收购企业"),
    _38("38", "住房租赁企业"),
    _39("39", "冬奥会退税企业");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    IndustryNaturePropertiesList(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IndustryNaturePropertiesList fromCode(String code) {
        return Stream.of(IndustryNaturePropertiesList.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
