package com.xforceplus.ultraman.app.jcprojectoperation.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_flag
 * </p>
 *
 * @author ultraman
 * @since 2024-06-03
 */
public enum InvoiceFlag {

    _0("0", "蓝字发票"),
    _1("1", "红字发票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceFlag fromCode(String code) {
        return Stream.of(InvoiceFlag.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
