package com.xforceplus.ultraman.app.jcprojectoperation.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_style_type
 * </p>
 *
 * @author ultraman
 * @since 2024-06-03
 */
public enum InvoiceStyleType {

    _01("01", "成品油发票"),
    _02("02", "稀土发票"),
    _03("03", "建筑服务发票"),
    _04("04", "货物运输服务发票"),
    _05("05", "不定产销售服务发票"),
    _06("06", "不动产租赁服务发票"),
    _07("07", "代收车船税"),
    _08("08", "通行费"),
    _09("09", "旅客运输服务发票"),
    _10("10", "医疗服务（住院）发票"),
    _11("11", "医疗服务（门诊）发票"),
    _12("12", "自产农产品销售服务"),
    _13("13", "拖拉机和联合收割机发票"),
    _14("14", "机动车"),
    _15("15", "二手车"),
    _16("16", "农产品收购发票"),
    _17("17", "光伏收购发票"),
    _18("18", "卷烟发票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceStyleType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceStyleType fromCode(String code) {
        return Stream.of(InvoiceStyleType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
