package com.xforceplus.ultraman.app.jcprojectoperation.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoicetype
 * </p>
 *
 * @author ultraman
 * @since 2024-06-03
 */
public enum Invoicetype {

    QC("qc", "数电普电"),
    QS("qs", "数电专电"),
    CZ("cz", "数电普纸"),
    SZ("sz", "数电专纸"),
    CE("ce", "税控普电"),
    C("c", "税控普纸"),
    SE("se", "税控专电"),
    S("s", "税控专纸"),
    V("v", "机动车统一销售发票"),
    CT("ct", "增值税电子普通发票（通行费）"),
    VS("vs", "二手车销售统一发票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Invoicetype(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Invoicetype fromCode(String code) {
        return Stream.of(Invoicetype.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
