package com.xforceplus.ultraman.app.jcprojectoperation.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoicing_method
 * </p>
 *
 * @author ultraman
 * @since 2024-06-03
 */
public enum InvoicingMethod {

    _1("1", "手工开票"),
    _2("2", "接口开票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoicingMethod(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoicingMethod fromCode(String code) {
        return Stream.of(InvoicingMethod.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
