package com.xforceplus.ultraman.app.jcprojectoperation.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * redapplicant
 * </p>
 *
 * @author ultraman
 * @since 2024-06-03
 */
public enum Redapplicant {

    AR("AR", "销方"),
    AP("AP", "购方");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Redapplicant(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Redapplicant fromCode(String code) {
        return Stream.of(Redapplicant.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
