package com.xforceplus.ultraman.app.jcprojectoperation.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * redstatus
 * </p>
 *
 * @author ultraman
 * @since 2024-06-03
 */
public enum Redstatus {

    _01("01", "无需确认"),
    _02("02", "销方录入待购方确认"),
    _03("03", "购方录入待销方确认");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Redstatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Redstatus fromCode(String code) {
        return Stream.of(Redstatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
