package com.xforceplus.ultraman.app.jcprojectoperation.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * settlement_mode
 * </p>
 *
 * @author ultraman
 * @since 2024-06-03
 */
public enum SettlementMode {

    _01("01", "现金"),
    _02("02", "银行转账"),
    _03("03", "票据"),
    _04("04", "第三方支付"),
    _05("05", "预付卡"),
    _99("99", "其他");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SettlementMode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SettlementMode fromCode(String code) {
        return Stream.of(SettlementMode.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
