package com.xforceplus.ultraman.app.jcprojectoperation.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * summary_status
 * </p>
 *
 * @author ultraman
 * @since 2024-06-03
 */
public enum SummaryStatus {

    _0("0", "待确认"),
    _1("1", "已确认");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SummaryStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SummaryStatus fromCode(String code) {
        return Stream.of(SummaryStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
