package com.xforceplus.ultraman.app.jcprojectoperation.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * taxpayer_risk_type
 * </p>
 *
 * @author ultraman
 * @since 2024-06-03
 */
public enum TaxpayerRiskType {

    _01("01", "Ⅰ类（高风险）纳税人"),
    _02("02", "Ⅱ类（中风险）纳税人"),
    _03("03", "Ⅲ类（低风险）纳税人"),
    _04("04", "Ⅳ类（无风险）纳税人");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TaxpayerRiskType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaxpayerRiskType fromCode(String code) {
        return Stream.of(TaxpayerRiskType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
