package com.xforceplus.ultraman.app.jcprojectoperation.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * taxpayer_type
 * </p>
 *
 * @author ultraman
 * @since 2024-06-03
 */
public enum TaxpayerType {

    _1("1", "一般纳税人"),
    _2("2", "小规模纳税人"),
    _3("3", "转登记小规模纳税人"),
    _4("4", "辅导期一般纳税人"),
    _5("5", "自然人");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TaxpayerType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaxpayerType fromCode(String code) {
        return Stream.of(TaxpayerType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
