package com.xforceplus.ultraman.app.jcprojectoperation.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * api_access_log
 * </p>
 *
 * @author ultraman
 * @since 2024-06-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ApiAccessLog implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 链路追踪编号
   */
  private String traceId;
  /**
   * 用户编号
   */
  private Long userId;
  /**
   * 用户类型
   */
  private Long userType;
  /**
   * 应用名
   */
  private String applicationName;
  /**
   * 请求方法名
   */
  private String requestMethod;
  /**
   * 请求地址
   */
  private String requestUrl;
  /**
   * 请求参数
   */
  private String requestParams;
  /**
   * 用户 IP
   */
  private String userIp;
  /**
   * 浏览器 UA
   */
  private String userAgent;
  /**
   * 开始请求时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime beginTime;
  /**
   * 结束请求时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime endTime;
  /**
   * 执行时长
   */
  private Long duration;
  /**
   * 结果码
   */
  private Long resultCode;
  /**
   * 结果提示
   */
  private String resultMsg;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("trace_id", traceId);
      map.put("user_id", userId);
      map.put("user_type", userType);
      map.put("application_name", applicationName);
      map.put("request_method", requestMethod);
      map.put("request_url", requestUrl);
      map.put("request_params", requestParams);
      map.put("user_ip", userIp);
      map.put("user_agent", userAgent);
      map.put("begin_time", BocpGenUtils.toTimestamp(beginTime));
      map.put("end_time", BocpGenUtils.toTimestamp(endTime));
      map.put("duration", duration);
      map.put("result_code", resultCode);
      map.put("result_msg", resultMsg);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static ApiAccessLog fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    ApiAccessLog entity = new ApiAccessLog();

    if(map.containsKey("trace_id")) {
      Object obj = map.get("trace_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTraceId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("user_id")) {
      Object obj = map.get("user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("user_type")) {
      Object obj = map.get("user_type");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUserType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUserType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUserType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("application_name")) {
      Object obj = map.get("application_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplicationName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("request_method")) {
      Object obj = map.get("request_method");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRequestMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("request_url")) {
      Object obj = map.get("request_url");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRequestUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("request_params")) {
      Object obj = map.get("request_params");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRequestParams((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("user_ip")) {
      Object obj = map.get("user_ip");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUserIp((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("user_agent")) {
      Object obj = map.get("user_agent");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUserAgent((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("begin_time")) {
      Object obj = map.get("begin_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBeginTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setBeginTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBeginTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBeginTime(null);
      }
    }
    if(map.containsKey("end_time")) {
      Object obj = map.get("end_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEndTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setEndTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setEndTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEndTime(null);
      }
    }
    if(map.containsKey("duration")) {
      Object obj = map.get("duration");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDuration((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDuration(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setDuration(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("result_code")) {
      Object obj = map.get("result_code");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setResultCode((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setResultCode(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setResultCode(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("result_msg")) {
      Object obj = map.get("result_msg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setResultMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("trace_id")) {
      Object obj = map.get("trace_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTraceId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("user_id")) {
      Object obj = map.get("user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("user_type")) {
      Object obj = map.get("user_type");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUserType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUserType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUserType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("application_name")) {
      Object obj = map.get("application_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setApplicationName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("request_method")) {
      Object obj = map.get("request_method");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRequestMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("request_url")) {
      Object obj = map.get("request_url");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRequestUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("request_params")) {
      Object obj = map.get("request_params");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRequestParams((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("user_ip")) {
      Object obj = map.get("user_ip");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUserIp((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("user_agent")) {
      Object obj = map.get("user_agent");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUserAgent((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("begin_time")) {
      Object obj = map.get("begin_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setBeginTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setBeginTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBeginTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setBeginTime(null);
      }
    }
    if(map.containsKey("end_time")) {
      Object obj = map.get("end_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setEndTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setEndTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setEndTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setEndTime(null);
      }
    }
    if(map.containsKey("duration")) {
      Object obj = map.get("duration");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setDuration((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDuration(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setDuration(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("result_code")) {
      Object obj = map.get("result_code");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setResultCode((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setResultCode(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setResultCode(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("result_msg")) {
      Object obj = map.get("result_msg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setResultMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
  }
}
