package com.xforceplus.ultraman.app.jcprojectoperation.metadata.validator;

import com.xforceplus.ultraman.app.jcprojectoperation.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.jcprojectoperation.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-06-03
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(FlowStatus.class)) {
            isValid = null != FlowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = null != SnapshotFormat.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(BillNoException.class)) {
            isValid = null != BillNoException.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillNoException.class.getSimpleName());
            }
        }
        if(clazz.equals(PreException.class)) {
            isValid = null != PreException.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PreException.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceException.class)) {
            isValid = null != InvoiceException.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceException.class.getSimpleName());
            }
        }
        if(clazz.equals(RedType.class)) {
            isValid = null != RedType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RedType.class.getSimpleName());
            }
        }
        if(clazz.equals(RedException.class)) {
            isValid = null != RedException.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RedException.class.getSimpleName());
            }
        }
        if(clazz.equals(Pretimeout.class)) {
            isValid = null != Pretimeout.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Pretimeout.class.getSimpleName());
            }
        }
        if(clazz.equals(Invoiceurltimeout.class)) {
            isValid = null != Invoiceurltimeout.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Invoiceurltimeout.class.getSimpleName());
            }
        }
        if(clazz.equals(Redapplicant.class)) {
            isValid = null != Redapplicant.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Redapplicant.class.getSimpleName());
            }
        }
        if(clazz.equals(AppStatus.class)) {
            isValid = null != AppStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AppStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(Invoicetype.class)) {
            isValid = null != Invoicetype.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Invoicetype.class.getSimpleName());
            }
        }
        if(clazz.equals(Invoicecolor.class)) {
            isValid = null != Invoicecolor.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Invoicecolor.class.getSimpleName());
            }
        }
        if(clazz.equals(Reversereason.class)) {
            isValid = null != Reversereason.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Reversereason.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStyleType.class)) {
            isValid = null != InvoiceStyleType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceStyleType.class.getSimpleName());
            }
        }
        if(clazz.equals(VatRefundType.class)) {
            isValid = null != VatRefundType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, VatRefundType.class.getSimpleName());
            }
        }
        if(clazz.equals(SettlementMode.class)) {
            isValid = null != SettlementMode.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SettlementMode.class.getSimpleName());
            }
        }
        if(clazz.equals(Status.class)) {
            isValid = null != Status.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Status.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxIncentivesType.class)) {
            isValid = null != TaxIncentivesType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaxIncentivesType.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceFlag.class)) {
            isValid = null != InvoiceFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoicingMethod.class)) {
            isValid = null != InvoicingMethod.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoicingMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(Redstatus.class)) {
            isValid = null != Redstatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Redstatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ConfirmStatus.class)) {
            isValid = null != ConfirmStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ConfirmStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(VATaxPurpose.class)) {
            isValid = null != VATaxPurpose.fromCode(value);
            if(!isValid) {
                unValidMsg(context, VATaxPurpose.class.getSimpleName());
            }
        }
        if(clazz.equals(ExcisePurpose.class)) {
            isValid = null != ExcisePurpose.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ExcisePurpose.class.getSimpleName());
            }
        }
        if(clazz.equals(InAccountStatus.class)) {
            isValid = null != InAccountStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InAccountStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxpayerType.class)) {
            isValid = null != TaxpayerType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaxpayerType.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxpayerCreditRating.class)) {
            isValid = null != TaxpayerCreditRating.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaxpayerCreditRating.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxpayerRiskType.class)) {
            isValid = null != TaxpayerRiskType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaxpayerRiskType.class.getSimpleName());
            }
        }
        if(clazz.equals(ExportEnterprisesType.class)) {
            isValid = null != ExportEnterprisesType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ExportEnterprisesType.class.getSimpleName());
            }
        }
        if(clazz.equals(IndustryNaturePropertiesList.class)) {
            isValid = null != IndustryNaturePropertiesList.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IndustryNaturePropertiesList.class.getSimpleName());
            }
        }
        if(clazz.equals(ExciseTaxpayerTypeList.class)) {
            isValid = null != ExciseTaxpayerTypeList.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ExciseTaxpayerTypeList.class.getSimpleName());
            }
        }
        if(clazz.equals(YorN.class)) {
            isValid = null != YorN.fromCode(value);
            if(!isValid) {
                unValidMsg(context, YorN.class.getSimpleName());
            }
        }
        if(clazz.equals(Discounttype.class)) {
            isValid = null != Discounttype.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Discounttype.class.getSimpleName());
            }
        }
        if(clazz.equals(SummaryStatus.class)) {
            isValid = null != SummaryStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SummaryStatus.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
