package com.xforceplus.ultraman.app.jcprojectoperation.metadata.validator;

import com.xforceplus.ultraman.app.jcprojectoperation.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.jcprojectoperation.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-06-03
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(FlowStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FlowStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SnapshotFormat.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(BillNoException.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillNoException.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillNoException.class.getSimpleName());
            }
        }
        if(clazz.equals(PreException.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PreException.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PreException.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceException.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceException.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceException.class.getSimpleName());
            }
        }
        if(clazz.equals(RedType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RedType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RedType.class.getSimpleName());
            }
        }
        if(clazz.equals(RedException.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RedException.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RedException.class.getSimpleName());
            }
        }
        if(clazz.equals(Pretimeout.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Pretimeout.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Pretimeout.class.getSimpleName());
            }
        }
        if(clazz.equals(Invoiceurltimeout.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Invoiceurltimeout.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Invoiceurltimeout.class.getSimpleName());
            }
        }
        if(clazz.equals(Redapplicant.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Redapplicant.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Redapplicant.class.getSimpleName());
            }
        }
        if(clazz.equals(AppStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AppStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AppStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(Invoicetype.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Invoicetype.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Invoicetype.class.getSimpleName());
            }
        }
        if(clazz.equals(Invoicecolor.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Invoicecolor.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Invoicecolor.class.getSimpleName());
            }
        }
        if(clazz.equals(Reversereason.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Reversereason.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Reversereason.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStyleType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceStyleType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceStyleType.class.getSimpleName());
            }
        }
        if(clazz.equals(VatRefundType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != VatRefundType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, VatRefundType.class.getSimpleName());
            }
        }
        if(clazz.equals(SettlementMode.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SettlementMode.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SettlementMode.class.getSimpleName());
            }
        }
        if(clazz.equals(Status.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Status.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Status.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxIncentivesType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaxIncentivesType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaxIncentivesType.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoicingMethod.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoicingMethod.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoicingMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(Redstatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Redstatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Redstatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ConfirmStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ConfirmStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ConfirmStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(VATaxPurpose.class)) {
            isValid = vals.stream()
                    .filter(val -> null != VATaxPurpose.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, VATaxPurpose.class.getSimpleName());
            }
        }
        if(clazz.equals(ExcisePurpose.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ExcisePurpose.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ExcisePurpose.class.getSimpleName());
            }
        }
        if(clazz.equals(InAccountStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InAccountStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InAccountStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxpayerType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaxpayerType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaxpayerType.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxpayerCreditRating.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaxpayerCreditRating.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaxpayerCreditRating.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxpayerRiskType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaxpayerRiskType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaxpayerRiskType.class.getSimpleName());
            }
        }
        if(clazz.equals(ExportEnterprisesType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ExportEnterprisesType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ExportEnterprisesType.class.getSimpleName());
            }
        }
        if(clazz.equals(IndustryNaturePropertiesList.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IndustryNaturePropertiesList.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IndustryNaturePropertiesList.class.getSimpleName());
            }
        }
        if(clazz.equals(ExciseTaxpayerTypeList.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ExciseTaxpayerTypeList.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ExciseTaxpayerTypeList.class.getSimpleName());
            }
        }
        if(clazz.equals(YorN.class)) {
            isValid = vals.stream()
                    .filter(val -> null != YorN.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, YorN.class.getSimpleName());
            }
        }
        if(clazz.equals(Discounttype.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Discounttype.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Discounttype.class.getSimpleName());
            }
        }
        if(clazz.equals(SummaryStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SummaryStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SummaryStatus.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
