package com.xforceplus.ultraman.app.jcprojectoperation.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoiceurltimeout
 * </p>
 *
 * @author ultraman
 * @since 2024-03-06
 */
public enum Invoiceurltimeout {

    _1("1", "0-5min"),
    _2("2", "5min-1h"),
    _3("3", "1h-1d"),
    _4("4", "大于1d");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Invoiceurltimeout(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Invoiceurltimeout fromCode(String code) {
        return Stream.of(Invoiceurltimeout.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
