package com.xforceplus.ultraman.app.jcprojectoperation.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * pre_exception
 * </p>
 *
 * @author ultraman
 * @since 2024-03-06
 */
public enum PreException {

    _1("1", "超时开票"),
    _2("2", "一直未开票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PreException(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PreException fromCode(String code) {
        return Stream.of(PreException.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
