package com.xforceplus.ultraman.app.jcprojectoperation.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * red_exception
 * </p>
 *
 * @author ultraman
 * @since 2024-03-06
 */
public enum RedException {

    _1("1", "超时申请");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RedException(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RedException fromCode(String code) {
        return Stream.of(RedException.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
