package com.xforceplus.ultraman.app.jcprojectoperation.metadata.validator;

import com.xforceplus.ultraman.app.jcprojectoperation.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.jcprojectoperation.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-03-06
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(FlowStatus.class)) {
            isValid = null != FlowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = null != SnapshotFormat.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(BillNoException.class)) {
            isValid = null != BillNoException.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillNoException.class.getSimpleName());
            }
        }
        if(clazz.equals(PreException.class)) {
            isValid = null != PreException.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PreException.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceException.class)) {
            isValid = null != InvoiceException.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceException.class.getSimpleName());
            }
        }
        if(clazz.equals(RedType.class)) {
            isValid = null != RedType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RedType.class.getSimpleName());
            }
        }
        if(clazz.equals(RedException.class)) {
            isValid = null != RedException.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RedException.class.getSimpleName());
            }
        }
        if(clazz.equals(Pretimeout.class)) {
            isValid = null != Pretimeout.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Pretimeout.class.getSimpleName());
            }
        }
        if(clazz.equals(Invoiceurltimeout.class)) {
            isValid = null != Invoiceurltimeout.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Invoiceurltimeout.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
