package com.xforceplus.ultraman.app.jcprojectoperation.metadata.validator;

import com.xforceplus.ultraman.app.jcprojectoperation.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.jcprojectoperation.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-03-06
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(FlowStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FlowStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SnapshotFormat.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(BillNoException.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillNoException.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillNoException.class.getSimpleName());
            }
        }
        if(clazz.equals(PreException.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PreException.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PreException.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceException.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceException.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceException.class.getSimpleName());
            }
        }
        if(clazz.equals(RedType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RedType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RedType.class.getSimpleName());
            }
        }
        if(clazz.equals(RedException.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RedException.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RedException.class.getSimpleName());
            }
        }
        if(clazz.equals(Pretimeout.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Pretimeout.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Pretimeout.class.getSimpleName());
            }
        }
        if(clazz.equals(Invoiceurltimeout.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Invoiceurltimeout.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Invoiceurltimeout.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
