package com.xforceplus.ultraman.app.jcprojectoperation.metadata.validator;

import com.xforceplus.ultraman.app.jcprojectoperation.metadata.validator.annotation.CheckUltramanPhone;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.regex.Pattern;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-03-06
 */
public class UltramanPhoneConstraintValidator implements ConstraintValidator<CheckUltramanPhone, String> {

    private final String MSG_FORMAT = "value must be phone number";

    private final String TYPE_PHONE = "1";

    private final String TYPE_OTHER = "2";

    String type;

    @Override
    public void initialize(CheckUltramanPhone constraintAnnotation) {
        type = constraintAnnotation.type();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }
        if(!TYPE_PHONE.equals(type)) {
            return true;
        }

        boolean isValid = Pattern.matches("^[1-9]\\d{10}$", value);

        if(!isValid) {
            unValidMsg(context);
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT))
                .addConstraintViolation();
    }
}
