package com.xforceplus.ultraman.app.jcrcjtcx.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcrcjtcx.entity.CompanyDomain;
import com.xforceplus.ultraman.app.jcrcjtcx.service.ICompanyDomainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-22
 */
@RestController
public class CompanyDomainController {

  @Autowired
  private ICompanyDomainService companyDomainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param companyDomain ${table.comment}
   * @return
   */
  @GetMapping("/companydomains" )
  public XfR getCompanyDomains(XfPage page, CompanyDomain companyDomain) {
    return XfR.ok(companyDomainServiceImpl.page(page, Wrappers.query(companyDomain)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/companydomains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(companyDomainServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param companyDomain ${table.comment}
   * @return XfR
   */
  @PostMapping("/companydomains")
  public XfR save(@RequestBody CompanyDomain companyDomain) {
     return XfR.ok(companyDomainServiceImpl.save(companyDomain));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param companyDomain ${table.comment}
   * @return XfR
   */
  @PutMapping("/companydomains/{id}")
  public XfR putUpdate(@RequestBody CompanyDomain companyDomain,@PathVariable Long id) {
      companyDomain.setId(id);
      return XfR.ok(companyDomainServiceImpl.updateById(companyDomain));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param companyDomain ${table.comment}
   * @return XfR
   */
  @PatchMapping("/companydomains/{id}")
  public XfR patchUpdate(@RequestBody CompanyDomain companyDomain,@PathVariable Long id) {
      CompanyDomain upcompanyDomain = companyDomainServiceImpl.getById(id);
      if(upcompanyDomain != null){
        upcompanyDomain = ObjectCopyUtils.copyProperties(companyDomain,upcompanyDomain,true);
      }
      return XfR.ok(companyDomainServiceImpl.updateById(upcompanyDomain));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/companydomains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(companyDomainServiceImpl.removeById(id));
  }

  @PostMapping("/companydomains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "company_domain");
     params.put("request", condition);

     return XfR.ok(companyDomainServiceImpl.querys(params));
  }

}
