package com.xforceplus.ultraman.app.jcrcjtcx.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcrcjtcx.entity.CompanyInfo;
import com.xforceplus.ultraman.app.jcrcjtcx.service.ICompanyInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-22
 */
@RestController
public class CompanyInfoController {

  @Autowired
  private ICompanyInfoService companyInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param companyInfo ${table.comment}
   * @return
   */
  @GetMapping("/companyinfos" )
  public XfR getCompanyInfos(XfPage page, CompanyInfo companyInfo) {
    return XfR.ok(companyInfoServiceImpl.page(page, Wrappers.query(companyInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/companyinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(companyInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param companyInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/companyinfos")
  public XfR save(@RequestBody CompanyInfo companyInfo) {
     return XfR.ok(companyInfoServiceImpl.save(companyInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param companyInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/companyinfos/{id}")
  public XfR putUpdate(@RequestBody CompanyInfo companyInfo,@PathVariable Long id) {
      companyInfo.setId(id);
      return XfR.ok(companyInfoServiceImpl.updateById(companyInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param companyInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/companyinfos/{id}")
  public XfR patchUpdate(@RequestBody CompanyInfo companyInfo,@PathVariable Long id) {
      CompanyInfo upcompanyInfo = companyInfoServiceImpl.getById(id);
      if(upcompanyInfo != null){
        upcompanyInfo = ObjectCopyUtils.copyProperties(companyInfo,upcompanyInfo,true);
      }
      return XfR.ok(companyInfoServiceImpl.updateById(upcompanyInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/companyinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(companyInfoServiceImpl.removeById(id));
  }

  @PostMapping("/companyinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "company_info");
     params.put("request", condition);

     return XfR.ok(companyInfoServiceImpl.querys(params));
  }

}
