package com.xforceplus.ultraman.app.jcrichemont.controller;


/**
 * 组合结算单号表feign客户端
 *
 * @author ultraman
 * @date 2024-03-18
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcrichemont.entity.ChangePosNo;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-richemont")
public interface ChangePosNoFeignApi {

  /**
   * 通过id查询组合结算单号表
   * @param  id
   * @return R
   */
  @GetMapping("/changePosNo/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增组合结算单号表
   * @param changePosNo 组合结算单号表
   * @return R
   */
  @PostMapping("/changePosNo/add")
  public R save(@RequestBody ChangePosNo changePosNo);

  /**
   * 修改组合结算单号表
   * @param changePosNo 组合结算单号表
   * @return R
   */
  @PostMapping("/changePosNo/update")
  public R updateById(@RequestBody ChangePosNo changePosNo);

  /**
   * 通过id删除组合结算单号表
   * @param  id
   * @return R
   */
  @DeleteMapping("/changePosNo/del/{id}" )
  public R removeById(@PathVariable Long id);

}