package com.xforceplus.ultraman.app.jcrichemont.controller;


/**
 * 订单明细表feign客户端
 *
 * @author ultraman
 * @date 2024-07-05
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcrichemont.entity.OrderInfoDetail;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-richemont")
public interface OrderInfoDetailFeignApi {

  /**
   * 通过id查询订单明细表
   * @param  id
   * @return R
   */
  @GetMapping("/orderInfoDetail/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增订单明细表
   * @param orderInfoDetail 订单明细表
   * @return R
   */
  @PostMapping("/orderInfoDetail/add")
  public R save(@RequestBody OrderInfoDetail orderInfoDetail);

  /**
   * 修改订单明细表
   * @param orderInfoDetail 订单明细表
   * @return R
   */
  @PostMapping("/orderInfoDetail/update")
  public R updateById(@RequestBody OrderInfoDetail orderInfoDetail);

  /**
   * 通过id删除订单明细表
   * @param  id
   * @return R
   */
  @DeleteMapping("/orderInfoDetail/del/{id}" )
  public R removeById(@PathVariable Long id);

}