package com.xforceplus.ultraman.app.jcrichemont.controller;


/**
 * 发票主表feign客户端
 *
 * @author ultraman
 * @date 2024-07-05
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcrichemont.entity.SellerInvoiceMain;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-richemont")
public interface SellerInvoiceMainFeignApi {

  /**
   * 通过id查询发票主表
   * @param  id
   * @return R
   */
  @GetMapping("/sellerInvoiceMain/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增发票主表
   * @param sellerInvoiceMain 发票主表
   * @return R
   */
  @PostMapping("/sellerInvoiceMain/add")
  public R save(@RequestBody SellerInvoiceMain sellerInvoiceMain);

  /**
   * 修改发票主表
   * @param sellerInvoiceMain 发票主表
   * @return R
   */
  @PostMapping("/sellerInvoiceMain/update")
  public R updateById(@RequestBody SellerInvoiceMain sellerInvoiceMain);

  /**
   * 通过id删除发票主表
   * @param  id
   * @return R
   */
  @DeleteMapping("/sellerInvoiceMain/del/{id}" )
  public R removeById(@PathVariable Long id);

}